{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitGlobus;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, MMSystem, StdCtrls;

type
  TFormGlobus = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    CheckBoxDecibels: TCheckBox;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
    procedure CheckBoxDecibelsClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    RadiCercle:integer;
    RadiCercleConstant:integer;
  end;

var
  FormGlobus: TFormGlobus;

{************************************************}
IMPLEMENTATION
{************************************************}

uses UnitEntradaSo, UnitTools;

{$R *.DFM}

procedure TFormGlobus.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if not (SpeedButtonEngegarParar.Caption='E') then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
  end;
end;

procedure TFormGlobus.SpeedButtonEngegarPararClick(Sender: TObject);
begin
  if SpeedButtonEngegarParar.Caption='E' then begin
    SpeedButtonEngegarParar.Caption:='P';
    RePaint;
    IniciarDadesUnitEntradaSo(128);
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
  end;
end;

procedure TFormGlobus.WMWIMDATA(var Msg: TMessage);
var
  i,Max:integer;
begin
  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  if CheckBoxDecibels.Checked then begin
    if Max<1 then Max:=1;
    Max:=Round(10*ln(sqr(Max)/sqr(127))/ln(10));
    Max:=126+3*Max;
  end;
  RadiCercle:=Max+10;
  Repaint;
  EntradaSo;
end;

procedure TFormGlobus.FormCreate(Sender: TObject);
begin
  RadiCercle:=10;
  RadiCercleConstant:=RadiCercle;
  Canvas.Brush.Color:=clRed;
end;

procedure TFormGlobus.FormPaint(Sender: TObject);
var
  i,n,m:integer;
begin
  if CheckBoxDecibels.Checked then begin
    Canvas.MoveTo((Width div 2),(Height div 2));
    Canvas.LineTo((Width div 2)+136,(Height div 2));
    i:=(Width div 2)+136;
    n:=0;
    while i>(Width div 2) do begin
      if (i-((Width div 2)+136)) mod 30 = 0 then m:=4 else m:=2;
      Canvas.MoveTo(i,(Height div 2)-m);
      Canvas.LineTo(i,(Height div 2)+m);
      Canvas.Brush.Color:=clWhite;
      if (i-((Width div 2)+136)) mod 30 = 0 then begin
        Canvas.TextOut(i,(Height div 2)+6,IntToStr(n));
        n:=n-10;
      end;
      i:=i-3;
    end;
  end;
  if RadiCercleConstant<RadiCercle then Canvas.Brush.Color:=clBlue else Canvas.Brush.Color:=clRed;
  Canvas.Ellipse((Width div 2)-RadiCercle,(Height div 2)-RadiCercle,(Width div 2)+RadiCercle,(Height div 2)+RadiCercle);
  if RadiCercleConstant>10 then
   Canvas.Arc((Width div 2)-RadiCercleConstant,(Height div 2)-RadiCercleConstant,(Width div 2)+RadiCercleConstant,(Height div 2)+RadiCercleConstant,(Width div 2)-RadiCercleConstant,(Height div 2),(Width div 2)-RadiCercleConstant,(Height div 2));
end;

procedure TFormGlobus.FormMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
    if not(SpeedButtonEngegarParar.Caption='E') then RadiCercleConstant:=RadiCercle;
  end else begin
    if (not (SpeedButtonEngegarParar.Caption='E')) and (RadiCercleConstant=10) then begin
      PararEntradaSo;
      FinalitzarEntradaSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
    end;
    RadiCercleConstant:=10;
    if SpeedButtonEngegarParar.Caption='E' then Repaint;
  end;
end;

procedure TFormGlobus.CheckBoxDecibelsClick(Sender: TObject);
begin
  Repaint;
  if CheckBoxDecibels.Checked then
   writePrivateProfileString('Globus','Decibels','SI','globus3.ini')
  else
   writePrivateProfileString('Globus','Decibels','NO','globus3.ini')
end;

procedure TFormGlobus.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

end.
